#include <Python.h>
#include <stdbool.h>
#include <stdio.h>
#include <unistd.h>
#include <math.h>
#include <string.h>
#include "ldadrvr.h"
#define FALSE 0
#define TRUE !FALSE
#define VERBOSE 1
#define WRAPPERVERSION "0.1"

// A module that takes no arguments
static PyObject* LDAEth_module_print_hello_world(PyObject *self, PyObject *args)
{
  printf("LDA cpy: Hello World\r\n");
  Py_RETURN_NONE;
}

/* This is the Vaunix-specific stuff. */
//void fnLDA_Init(void);
// A module that takes no arguments
static PyObject* LDAEth_module_fnLDA_Init(PyObject *self, PyObject *args)
{
  fnLDA_Init();
  Py_RETURN_NONE;
}

static PyObject* LDAEth_module_fnLDA_InitDevice(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
#if VERBOSE
      printf("Devie Ip Address: %s\r\n", (char *)pValue);
#endif
      fnLDA_InitDevice((char *)pValue);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_InitDevice expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_InitDevice expects one argument");
      return NULL;
  }	
  
  Py_XDECREF(str);
  Py_RETURN_NONE;
}


static PyObject* LDAEth_module_fnLDA_CheckDeviceReady(PyObject *self, PyObject *args)
{
	int n, result;
	PyObject *temp_p, *str;
	char *pValue;

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      result = fnLDA_CheckDeviceReady((char *)pValue);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_CheckDeviceReady expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_CheckDeviceReady expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(result);
}

static PyObject* LDAEth_module_fnLDA_GetModelName(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	char datastr[64];

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetModelName((char *)pValue,(char *)datastr);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetModelName expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetModelName expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyBytes_FromString(datastr);
}

static PyObject* LDAEth_module_fnLDA_GetSerialNumber(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	int idata;

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetSerialNumber((char *)pValue,&idata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetSerialNumber expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetSerialNumber expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(idata);
}

static PyObject* LDAEth_module_fnLDA_GetSoftwareVersion(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	char datastr[64];

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetSoftwareVersion((char *)pValue,(char *)datastr);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetSoftwareVersion expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetSoftwareVersion expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyBytes_FromString(datastr);
}

static PyObject* LDAEth_module_fnLDA_GetFeatures(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	int idata;

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetFeatures((char *)pValue,&idata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetFeatures expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetFeatures expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(idata);
}

static PyObject* LDAEth_module_fnLDA_GetMaxChannels(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	int idata;

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetMaxChannels((char *)pValue,&idata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetMaxChannels expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetMaxChannels expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(idata);
}

static PyObject* LDAEth_module_fnLDA_GetIPMode(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	int idata;

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetIPMode((char *)pValue,&idata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetIPMode expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetIPMode expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(idata);
}

static PyObject* LDAEth_module_fnLDA_GetIPAddress(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	char datastr[64];

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetIPAddress((char *)pValue,(char *)datastr);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetIPAddress expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetIPAddress expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyBytes_FromString(datastr);
}

static PyObject* LDAEth_module_fnLDA_GetNetmask(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	char datastr[64];

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetNetmask((char *)pValue,(char *)datastr);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetNetmask expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetNetmask expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyBytes_FromString(datastr);
}


static PyObject* LDAEth_module_fnLDA_GetGateway(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	char datastr[64];

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetGateway((char *)pValue,(char *)datastr);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetGateway expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetGateway expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyBytes_FromString(datastr);
}

static PyObject* LDAEth_module_fnLDA_GetMinWorkingFrequency(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	int idata;

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetMinWorkingFrequency((char *)pValue,&idata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetMinWorkingFrequency expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetMinWorkingFrequency expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(idata);
}

static PyObject* LDAEth_module_fnLDA_GetMaxWorkingFrequency(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	int idata;

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetMaxWorkingFrequency((char *)pValue,&idata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetMaxWorkingFrequency expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetMaxWorkingFrequency expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(idata);
}

static PyObject* LDAEth_module_fnLDA_GetMinAttenuation(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	int idata;

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetMinAttenuation((char *)pValue,&idata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetMinAttenuation expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetMinAttenuation expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(idata);
}

static PyObject* LDAEth_module_fnLDA_GetMaxAttenuation(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	int idata;

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetMaxAttenuation((char *)pValue,&idata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetMaxAttenuation expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetMaxAttenuation expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(idata);
}

static PyObject* LDAEth_module_fnLDA_GetChannel(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	int idata;

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetChannel((char *)pValue,&idata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetChannel expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetChannel expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(idata);
}

static PyObject* LDAEth_module_fnLDA_GetWorkingFrequency(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	int idata;

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetWorkingFrequency((char *)pValue,&idata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetWorkingFrequency expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetWorkingFrequency expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(idata);
}

static PyObject* LDAEth_module_fnLDA_GetAttenuation(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	int idata;

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetAttenuation((char *)pValue,&idata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetAttenuation expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetAttenuation expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(idata);
}

static PyObject* LDAEth_module_fnLDA_GetRampStart(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	int idata;

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetRampStart((char *)pValue,&idata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetRampStart expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetRampStart expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(idata);
}

static PyObject* LDAEth_module_fnLDA_GetRampEnd(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	int idata;

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetRampEnd((char *)pValue,&idata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetRampEnd expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetRampEnd expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(idata);
}

static PyObject* LDAEth_module_fnLDA_GetDwellTime(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	int idata;

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetDwellTime((char *)pValue,&idata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetDwellTime expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetDwellTime expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(idata);
}

static PyObject* LDAEth_module_fnLDA_GetIdleTime(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	int idata;

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetIdleTime((char *)pValue,&idata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetIdleTime expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetIdleTime expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(idata);
}

static PyObject* LDAEth_module_fnLDA_GetAttenuationStep(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	int idata;

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetAttenuationStep((char *)pValue,&idata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetAttenuationStep expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetAttenuationStep expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(idata);
}

static PyObject* LDAEth_module_fnLDA_GetDwellTimeTwo(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	int idata;

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetDwellTimeTwo((char *)pValue,&idata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetDwellTimeTwo expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetDwellTimeTwo expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(idata);
}

static PyObject* LDAEth_module_fnLDA_GetHoldTime(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	int idata;

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetHoldTime((char *)pValue,&idata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetHoldTime expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetHoldTime expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(idata);
}

static PyObject* LDAEth_module_fnLDA_GetAttenuationStepTwo(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	int idata;

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetAttenuationStepTwo((char *)pValue,&idata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetAttenuationStepTwo expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetAttenuationStepTwo expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(idata);
}

static PyObject* LDAEth_module_fnLDA_GetProfileCount(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	int idata;

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetProfileCount((char *)pValue,&idata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetProfileCount expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetProfileCount expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(idata);
}

static PyObject* LDAEth_module_fnLDA_GetProfileMaxLength(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	int idata;

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetProfileMaxLength((char *)pValue,&idata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetProfileMaxLength expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetProfileMaxLength expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(idata);
}

static PyObject* LDAEth_module_fnLDA_GetProfileDwellTime(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	int idata;

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetProfileDwellTime((char *)pValue,&idata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetProfileDwellTime expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetProfileDwellTime expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(idata);
}

static PyObject* LDAEth_module_fnLDA_GetProfileIdleTime(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	int idata;

	n = PyTuple_Size(args);
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      fnLDA_GetProfileIdleTime((char *)pValue,&idata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetProfileIdleTime expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetProfileIdleTime expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(idata);
}

static PyObject* LDAEth_module_fnLDA_GetProfileElement(PyObject *self, PyObject *args)
{
	int n;
	PyObject *temp_p, *str;
	char *pValue;
	int idata, index;

	n = PyTuple_Size(args);
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
	  temp_p = PyTuple_GetItem(args, 1);
      index = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
      fnLDA_GetProfileElement((char *)pValue, index, &idata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetProfileElement expects two arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_GetProfileElement expects two arguments");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(idata);
}
// Set API's
// Set Frequency
static PyObject* LDAEth_module_fnLDA_SetWorkingFrequency(PyObject *self, PyObject *args)
{
  int n, result;
  PyObject *temp_p, *str;
  char *pValue;
  int sdata;

  n = PyTuple_Size(args);
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
	  temp_p = PyTuple_GetItem(args, 1);
      sdata = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
      result = fnLDA_SetWorkingFrequency((char *)pValue, sdata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetWorkingFrequency expects two arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetWorkingFrequency expects two arguments");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(result);
}

// Set Channel
static PyObject* LDAEth_module_fnLDA_SetChannel(PyObject *self, PyObject *args)
{
  int n, result;
  PyObject *temp_p, *str;
  char *pValue;
  int sdata;

  n = PyTuple_Size(args);
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
	  temp_p = PyTuple_GetItem(args, 1);
      sdata = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
      result = fnLDA_SetChannel((char *)pValue, sdata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetChannel expects two arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetChannel expects two arguments");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(result);
}

// Set Attenuation
static PyObject* LDAEth_module_fnLDA_SetAttenuation(PyObject *self, PyObject *args)
{
  int n, result;
  PyObject *temp_p, *str;
  char *pValue;
  int sdata;

  n = PyTuple_Size(args);
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
	  temp_p = PyTuple_GetItem(args, 1);
      sdata = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
      result = fnLDA_SetAttenuation((char *)pValue, sdata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetAttenuation expects two arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetAttenuation expects two arguments");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(result);
}

// Set Attenuatuion Step
static PyObject* LDAEth_module_fnLDA_SetAttenuationStep(PyObject *self, PyObject *args)
{
  int n, result;
  PyObject *temp_p, *str;
  char *pValue;
  int sdata;

  n = PyTuple_Size(args);
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
	  temp_p = PyTuple_GetItem(args, 1);
      sdata = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
      result = fnLDA_SetAttenuationStep((char *)pValue, sdata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetAttenuationStep expects two arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetAttenuationStep expects two arguments");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(result);
}

// Set Ramp Start
static PyObject* LDAEth_module_fnLDA_SetRampStart(PyObject *self, PyObject *args)
{
  int n, result;
  PyObject *temp_p, *str;
  char *pValue;
  int sdata;

  n = PyTuple_Size(args);
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
	  temp_p = PyTuple_GetItem(args, 1);
      sdata = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
      result = fnLDA_SetRampStart((char *)pValue, sdata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetRampStart expects two arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetRampStart expects two arguments");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(result);
}

// Set Ramp End
static PyObject* LDAEth_module_fnLDA_SetRampEnd(PyObject *self, PyObject *args)
{
  int n, result;
  PyObject *temp_p, *str;
  char *pValue;
  int sdata;

  n = PyTuple_Size(args);
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
	  temp_p = PyTuple_GetItem(args, 1);
      sdata = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
      result = fnLDA_SetRampEnd((char *)pValue, sdata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetRampEnd expects two arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetRampEnd expects two arguments");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(result);
}

// Set Dwell Time
static PyObject* LDAEth_module_fnLDA_SetDwellTime(PyObject *self, PyObject *args)
{
  int n, result;
  PyObject *temp_p, *str;
  char *pValue;
  int sdata;

  n = PyTuple_Size(args);
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
	  temp_p = PyTuple_GetItem(args, 1);
      sdata = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
      result = fnLDA_SetDwellTime((char *)pValue, sdata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetDwellTime expects two arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetDwellTime expects two arguments");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(result);
}

// Set Idle Time
static PyObject* LDAEth_module_fnLDA_SetIdleTime(PyObject *self, PyObject *args)
{
  int n, result;
  PyObject *temp_p, *str;
  char *pValue;
  int sdata;

  n = PyTuple_Size(args);
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
	  temp_p = PyTuple_GetItem(args, 1);
      sdata = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
      result = fnLDA_SetIdleTime((char *)pValue, sdata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetIdleTime expects two arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetIdleTime expects two arguments");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(result);
}

// Set Ramp Direction
static PyObject* LDAEth_module_fnLDA_SetRampDirection(PyObject *self, PyObject *args)
{
  int n, result;
  PyObject *temp_p, *str;
  char *pValue;
  int sdata;

  n = PyTuple_Size(args);
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
	  temp_p = PyTuple_GetItem(args, 1);
      sdata = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
      result = fnLDA_SetRampDirection((char *)pValue, sdata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetRampDirection expects two arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetRampDirection expects two arguments");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(result);
}

// Set Ramp Mode
static PyObject* LDAEth_module_fnLDA_SetRampMode(PyObject *self, PyObject *args)
{
  int n, result;
  PyObject *temp_p, *str;
  char *pValue;
  int sdata;

  n = PyTuple_Size(args);
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
	  temp_p = PyTuple_GetItem(args, 1);
      sdata = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
      result = fnLDA_SetRampMode((char *)pValue, sdata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetRampMode expects two arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetRampMode expects two arguments");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(result);
}

// Set Ramp Bidirectional
static PyObject* LDAEth_module_fnLDA_SetRampBidirectional(PyObject *self, PyObject *args)
{
  int n, result;
  PyObject *temp_p, *str;
  char *pValue;
  int sdata;

  n = PyTuple_Size(args);
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
	  temp_p = PyTuple_GetItem(args, 1);
      sdata = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
      result = fnLDA_SetRampBidirectional((char *)pValue, sdata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetRampBidirectional expects two arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetRampBidirectional expects two arguments");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(result);
}

// Set Bi-directional Attenuatuion Step size
static PyObject* LDAEth_module_fnLDA_SetAttenuationStepTwo(PyObject *self, PyObject *args)
{
  int n, result;
  PyObject *temp_p, *str;
  char *pValue;
  int sdata;

  n = PyTuple_Size(args);
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
	  temp_p = PyTuple_GetItem(args, 1);
      sdata = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
      result = fnLDA_SetAttenuationStepTwo((char *)pValue, sdata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetAttenuationStepTwo expects two arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetAttenuationStepTwo expects two arguments");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(result);
}

// Set Bi-directional Dwell Time
static PyObject* LDAEth_module_fnLDA_SetDwellTimeTwo(PyObject *self, PyObject *args)
{
  int n, result;
  PyObject *temp_p, *str;
  char *pValue;
  int sdata;

  n = PyTuple_Size(args);
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
	  temp_p = PyTuple_GetItem(args, 1);
      sdata = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
      result = fnLDA_SetDwellTimeTwo((char *)pValue, sdata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetDwellTimeTwo expects two arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetDwellTimeTwo expects two arguments");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(result);
}

// Set Hold Time
static PyObject* LDAEth_module_fnLDA_SetHoldTime(PyObject *self, PyObject *args)
{
  int n, result;
  PyObject *temp_p, *str;
  char *pValue;
  int sdata;

  n = PyTuple_Size(args);
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
	  temp_p = PyTuple_GetItem(args, 1);
      sdata = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
      result = fnLDA_SetHoldTime((char *)pValue, sdata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetHoldTime expects two arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetHoldTime expects two arguments");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(result);
}

// Set Profile Count
static PyObject* LDAEth_module_fnLDA_SetProfileCount(PyObject *self, PyObject *args)
{
  int n, result;
  PyObject *temp_p, *str;
  char *pValue;
  int sdata;

  n = PyTuple_Size(args);
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
	  temp_p = PyTuple_GetItem(args, 1);
      sdata = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
      result = fnLDA_SetProfileCount((char *)pValue, sdata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetProfileCount expects two arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetProfileCount expects two arguments");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(result);
}

// Set Profile Idle Time
static PyObject* LDAEth_module_fnLDA_SetProfileIdleTime(PyObject *self, PyObject *args)
{
  int n, result;
  PyObject *temp_p, *str;
  char *pValue;
  int sdata;

  n = PyTuple_Size(args);
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
	  temp_p = PyTuple_GetItem(args, 1);
      sdata = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
      result = fnLDA_SetProfileIdleTime((char *)pValue, sdata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetProfileIdleTime expects two arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetProfileIdleTime expects two arguments");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(result);
}

// Set Profile Dwell Time
static PyObject* LDAEth_module_fnLDA_SetProfileDwellTime(PyObject *self, PyObject *args)
{
  int n, result;
  PyObject *temp_p, *str;
  char *pValue;
  int sdata;

  n = PyTuple_Size(args);
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
	  temp_p = PyTuple_GetItem(args, 1);
      sdata = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
      result = fnLDA_SetProfileDwellTime((char *)pValue, sdata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetProfileDwellTime expects two arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetProfileDwellTime expects two arguments");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(result);
}

// Set Profile Element
static PyObject* LDAEth_module_fnLDA_SetProfileElement(PyObject *self, PyObject *args)
{
  int n, result;
  PyObject *temp_p, *str;
  char *pValue;
  int sdata, index;

  n = PyTuple_Size(args);
  if (3 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
	  temp_p = PyTuple_GetItem(args, 1);
      index = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
	  temp_p = PyTuple_GetItem(args, 2);
      sdata = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
      result = fnLDA_SetProfileElement((char *)pValue, index, sdata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetProfileElement expects three arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SetProfileElement expects three arguments");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(result);
}

// Set Profile Mode
static PyObject* LDAEth_module_fnLDA_StartProfile(PyObject *self, PyObject *args)
{
  int n, result;
  PyObject *temp_p, *str;
  char *pValue;
  int sdata;

  n = PyTuple_Size(args);
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
	  temp_p = PyTuple_GetItem(args, 1);
      sdata = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
      result = fnLDA_StartProfile((char *)pValue, sdata);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_StartProfile expects two arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_StartProfile expects two arguments");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(result);
}

// Save Setting
static PyObject* LDAEth_module_fnLDA_SaveSettings(PyObject *self, PyObject *args)
{
  int n, result;
  PyObject *temp_p, *str;
  char *pValue;

  n = PyTuple_Size(args);
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
	str = PyUnicode_AsEncodedString(temp_p, "UTF-8", "strict");
    if ((pValue = PyBytes_AS_STRING(str))){
      result = fnLDA_SaveSettings((char *)pValue);
	} else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SaveSettings expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDAEth_module.fnLDA_SaveSettings expects one argument");
      return NULL;
  }	
  Py_XDECREF(str);
  return PyLong_FromLong(result);
}

static PyObject* LDAEth_module_WrapperVersion(PyObject *self, PyObject *args)
{
  return PyBytes_FromString(WRAPPERVERSION);
}
//Method definition object for this extension, these argumens mean:
//ml_name: The name of the method
//ml_meth: Function pointer to the method implementation
//ml_flags: Flags indicating special features of this method, such as
//          accepting arguments, accepting keyword arguments, being a
//          class method, or being a static method of a class.
//ml_doc:  Contents of this method's docstring
static PyMethodDef LDAEth_module_methods[] = { 
    {   
        "print_hello_world",
        LDAEth_module_print_hello_world,
        METH_NOARGS,
        "Print 'hello world' from a method defined in a C extension."
    },  
    {   
        "fnLDA_Init",
        LDAEth_module_fnLDA_Init,
        METH_NOARGS,
        "Set up the LDA device"
    },  
	{
        "fnLDA_InitDevice",
        LDAEth_module_fnLDA_InitDevice,
        METH_VARARGS,
        "Set up the LDA device initialization"		
	},
	{
        "fnLDA_CheckDeviceReady",
        LDAEth_module_fnLDA_CheckDeviceReady,
        METH_VARARGS,
        "Check the LDA device ready"				
	},
	{
        "fnLDA_GetModelName",
        LDAEth_module_fnLDA_GetModelName,
        METH_VARARGS,
        "Get the LDA model name"			
	},
	{
        "fnLDA_GetSerialNumber",
        LDAEth_module_fnLDA_GetSerialNumber,
        METH_VARARGS,
        "Get the LDA serial number"			
	},	
	{
        "fnLDA_GetSoftwareVersion",
        LDAEth_module_fnLDA_GetSoftwareVersion,
        METH_VARARGS,
        "Get the LDA software version"			
	},
	{
        "fnLDA_GetFeatures",
        LDAEth_module_fnLDA_GetFeatures,
        METH_VARARGS,
        "Get the LDA features"			
	},    
	{
        "fnLDA_GetMaxChannels",
        LDAEth_module_fnLDA_GetMaxChannels,
        METH_VARARGS,
        "Get the LDA max channels"			
	},   
	{
        "fnLDA_GetIPMode",
        LDAEth_module_fnLDA_GetIPMode,
        METH_VARARGS,
        "Get the LDA IP mode"			
	},   
	{
        "fnLDA_GetIPAddress",
        LDAEth_module_fnLDA_GetIPAddress,
        METH_VARARGS,
        "Get the LDA IP address"			
	},   
	{
        "fnLDA_GetNetmask",
        LDAEth_module_fnLDA_GetNetmask,
        METH_VARARGS,
        "Get the LDA netmask"			
	},   
	{
        "fnLDA_GetGateway",
        LDAEth_module_fnLDA_GetGateway,
        METH_VARARGS,
        "Get the LDA gateway"			
	},   	{
        "fnLDA_GetMinWorkingFrequency",
        LDAEth_module_fnLDA_GetMinWorkingFrequency,
        METH_VARARGS,
        "Get the LDA min frequency"			
	},   
	{
        "fnLDA_GetMaxWorkingFrequency",
        LDAEth_module_fnLDA_GetMaxWorkingFrequency,
        METH_VARARGS,
        "Get the LDA max frequency"			
	},   
	{
        "fnLDA_GetMinAttenuation",
        LDAEth_module_fnLDA_GetMinAttenuation,
        METH_VARARGS,
        "Get the LDA min attenuation"			
	},   
	{
        "fnLDA_GetMaxAttenuation",
        LDAEth_module_fnLDA_GetMaxAttenuation,
        METH_VARARGS,
        "Get the LDA max attenuation"			
	},   
	{
        "fnLDA_GetChannel",
        LDAEth_module_fnLDA_GetChannel,
        METH_VARARGS,
        "Get the LDA channel"			
	},   
	{
        "fnLDA_GetWorkingFrequency",
        LDAEth_module_fnLDA_GetWorkingFrequency,
        METH_VARARGS,
        "Get the LDA current frequency"			
	},   
	{
        "fnLDA_GetAttenuation",
        LDAEth_module_fnLDA_GetAttenuation,
        METH_VARARGS,
        "Get the LDA current attenuation"			
	},   
	{
        "fnLDA_GetRampStart",
        LDAEth_module_fnLDA_GetRampStart,
        METH_VARARGS,
        "Get the LDA ramp start attenuation"			
	},   
	{   
        "fnLDA_GetRampEnd",
        LDAEth_module_fnLDA_GetRampEnd,
        METH_VARARGS,
        "Get the LDA ramp end attenuation"
    },  
	{   
        "fnLDA_GetDwellTime",
        LDAEth_module_fnLDA_GetDwellTime,
        METH_VARARGS,
        "Get the ramp dwell time"
    },  
	{   
        "fnLDA_GetIdleTime",
        LDAEth_module_fnLDA_GetIdleTime,
        METH_VARARGS,
        "Get the ramp idle time"
    },   
	{   
        "fnLDA_GetAttenuationStep",
        LDAEth_module_fnLDA_GetAttenuationStep,
        METH_VARARGS,
        "Get the attenuation step size"
    },   
	{   
        "fnLDA_GetDwellTimeTwo",
        LDAEth_module_fnLDA_GetDwellTimeTwo,
        METH_VARARGS,
        "Get the bi-directional dwell time"
    },   
	{   
        "fnLDA_GetHoldTime",
        LDAEth_module_fnLDA_GetHoldTime,
        METH_VARARGS,
        "Get the bi-directional hold time"
    },   
	{   
        "fnLDA_GetAttenuationStepTwo",
        LDAEth_module_fnLDA_GetAttenuationStepTwo,
        METH_VARARGS,
        "Get the bi-directonal attenuation step size"
    },   
	{   
        "fnLDA_GetProfileCount",
        LDAEth_module_fnLDA_GetProfileCount,
        METH_VARARGS,
        "Get the LDA profile count"
    },  
	{   
        "fnLDA_GetProfileMaxLength",
        LDAEth_module_fnLDA_GetProfileMaxLength,
        METH_VARARGS,
        "Get the LDA profile max length"
    },  
	{   
        "fnLDA_GetProfileDwellTime",
        LDAEth_module_fnLDA_GetProfileDwellTime,
        METH_VARARGS,
        "Get the LDA profile dwell time"
    },  
	{   
        "fnLDA_GetProfileIdleTime",
        LDAEth_module_fnLDA_GetProfileIdleTime,
        METH_VARARGS,
        "Get the LDA profile idle time"
    },  
	{   
        "fnLDA_GetProfileElement",
        LDAEth_module_fnLDA_GetProfileElement,
        METH_VARARGS,
        "Get the LDA profile element"
    },
	{   
        "fnLDA_SetWorkingFrequency",
        LDAEth_module_fnLDA_SetWorkingFrequency,
        METH_VARARGS,
        "Set the frequency to LDA"
    },
	{   
        "fnLDA_SetChannel",
        LDAEth_module_fnLDA_SetChannel,
        METH_VARARGS,
        "Set the channel to LDA"
    },
	{   
        "fnLDA_SetAttenuation",
        LDAEth_module_fnLDA_SetAttenuation,
        METH_VARARGS,
        "Set the attenuation to LDA"
    },
	{   
        "fnLDA_SetAttenuationStep",
        LDAEth_module_fnLDA_SetAttenuationStep,
        METH_VARARGS,
        "Set the attenuation step size to LDA"
    },
	{   
        "fnLDA_SetRampStart",
        LDAEth_module_fnLDA_SetRampStart,
        METH_VARARGS,
        "Set the ramp start attenuation to LDA"
    },
	{   
        "fnLDA_SetRampEnd",
        LDAEth_module_fnLDA_SetRampEnd,
        METH_VARARGS,
        "Set the ramp end attenuation to LDA"
    },
	{   
        "fnLDA_SetDwellTime",
        LDAEth_module_fnLDA_SetDwellTime,
        METH_VARARGS,
        "Set the dwell time to LDA"
    },
	{   
        "fnLDA_SetIdleTime",
        LDAEth_module_fnLDA_SetIdleTime,
        METH_VARARGS,
        "Set the idle time to LDA"
    },
	{   
        "fnLDA_SetRampDirection",
        LDAEth_module_fnLDA_SetRampDirection,
        METH_VARARGS,
        "Set the ramp direction to LDA"
    },
	{   
        "fnLDA_SetRampMode",
        LDAEth_module_fnLDA_SetRampMode,
        METH_VARARGS,
        "Set the ramp mode to LDA"
    },
	{   
        "fnLDA_SetRampBidirectional",
        LDAEth_module_fnLDA_SetRampBidirectional,
        METH_VARARGS,
        "Set the Bi-directional ramp mode to LDA"
    },
	{   
        "fnLDA_SetAttenuationStepTwo",
        LDAEth_module_fnLDA_SetAttenuationStepTwo,
        METH_VARARGS,
        "Set the Bi-directional attenuation step size to LDA"
    },
	{   
        "fnLDA_SetDwellTimeTwo",
        LDAEth_module_fnLDA_SetDwellTimeTwo,
        METH_VARARGS,
        "Set the Bi-directional dwell time to LDA"
    },
	{   
        "fnLDA_SetHoldTime",
        LDAEth_module_fnLDA_SetHoldTime,
        METH_VARARGS,
        "Set the Bi-directional hold time to LDA"
    },
	{   
        "fnLDA_SetProfileCount",
        LDAEth_module_fnLDA_SetProfileCount,
        METH_VARARGS,
        "Set the profile count to LDA"
    },
	{   
        "fnLDA_SetProfileIdleTime",
        LDAEth_module_fnLDA_SetProfileIdleTime,
        METH_VARARGS,
        "Set the profile idle time to LDA"
    },
	{   
        "fnLDA_SetProfileDwellTime",
        LDAEth_module_fnLDA_SetProfileDwellTime,
        METH_VARARGS,
        "Set the profile dwell time to LDA"
    },
	{   
        "fnLDA_SetProfileElement",
        LDAEth_module_fnLDA_SetProfileElement,
        METH_VARARGS,
        "Set the profile element to LDA"
    },
	{   
        "fnLDA_StartProfile",
        LDAEth_module_fnLDA_StartProfile,
        METH_VARARGS,
        "Set the profile mode to LDA"
    },
	{   
        "fnLDA_SaveSettings",
        LDAEth_module_fnLDA_SaveSettings,
        METH_VARARGS,
        "Set the save settings to LDA"
    },
	{   
        "WrapperVersion",
        LDAEth_module_WrapperVersion,
        METH_NOARGS,
        "Returns the LDA library wrapper version"
    },  
    {NULL, NULL, 0, NULL}
};


//Module definition
//The arguments of this structure tell Python what to call your extension,
//what it's methods are and where to look for it's method definitions
static struct PyModuleDef LDAEth_module_definition = { 
    PyModuleDef_HEAD_INIT,
    "LDAEth_module",
    "A Python module for managing the Vaunix LDA series RF Attenuators.",
    -1, 
    LDAEth_module_methods
};

//Module initialization
//Python calls this function when importing your extension. It is important
//that this function is named PyInit_[[your_module_name]] exactly, and matches
//the name keyword argument in setup.py's setup() call.
PyMODINIT_FUNC PyInit_LDAEth_module(void)
{
    Py_Initialize();

    return PyModule_Create(&LDAEth_module_definition);
}

